/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import com.mckoi.database.global.ByteLongObject;
import com.mckoi.database.global.CastHelper;
import com.mckoi.database.global.ObjectTranslator;
import com.mckoi.database.global.StreamableObject;
import com.mckoi.database.global.StringObject;
import com.mckoi.database.jdbc.MConnection;
import com.mckoi.database.jdbc.MResultSet;
import com.mckoi.database.jdbc.MSQLException;
import com.mckoi.database.jdbc.MStatement;
import com.mckoi.database.jdbc.SQLQuery;
import com.mckoi.database.jdbc.UnicodeToBinaryStream;
import com.mckoi.util.BigNumber;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

class MPreparedStatement
extends MStatement
implements PreparedStatement {
    private SQLQuery statement;
    private static final boolean TIMESTAMP_VALUE_INCLUDES_NANOS = new Timestamp(5L).getTime() == 5L;

    MPreparedStatement(MConnection connection, String sql) {
        super(connection);
        this.statement = new SQLQuery(sql);
    }

    Object convertToType(Object ob, int sqlType) throws SQLException {
        return CastHelper.castObjectToSQLType(ob, sqlType, -1, -1, "requested type");
    }

    Object castToMckoiObject(Object ob) throws SQLException {
        if (ob == null) {
            return ob;
        }
        if (ob instanceof String) {
            return StringObject.fromString((String)ob);
        }
        if (ob instanceof Boolean) {
            return ob;
        }
        if (ob instanceof Number) {
            Number n = (Number)ob;
            if (ob instanceof Byte || ob instanceof Short || ob instanceof Integer) {
                return BigNumber.fromInt(n.intValue());
            }
            if (ob instanceof Long) {
                return BigNumber.fromLong(n.longValue());
            }
            if (ob instanceof Float) {
                return BigNumber.fromFloat(n.floatValue());
            }
            if (ob instanceof Double) {
                return BigNumber.fromDouble(n.doubleValue());
            }
            return BigNumber.fromString(n.toString());
        }
        if (ob instanceof byte[]) {
            return new ByteLongObject((byte[])ob);
        }
        try {
            return ObjectTranslator.translate(ob);
        }
        catch (Throwable e) {
            throw new SQLException(e.getMessage());
        }
    }

    private void setVariableLengthStream(int parameterIndex, InputStream x, int length, byte type) throws IOException {
        if (length > 8192) {
            int p_ind = parameterIndex - 1;
            StreamableObject s_object = this.createStreamableObject(x, length, type);
            this.statement.setVar(p_ind, s_object);
        } else if (type == 2) {
            ByteLongObject b = new ByteLongObject(x, length);
            this.statement.setVar(parameterIndex - 1, b);
        } else if (type == 3) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < length; ++i) {
                int v = x.read();
                if (v == -1) {
                    throw new IOException("Premature EOF reached.");
                }
                buf.append((char)v);
            }
            this.statement.setVar(parameterIndex - 1, StringObject.fromString(new String(buf)));
        } else if (type == 4) {
            StringBuffer buf = new StringBuffer();
            int half_len = length / 2;
            for (int i = 0; i < half_len; ++i) {
                int v1 = x.read();
                int v2 = x.read();
                if (v1 == -1 || v2 == -1) {
                    throw new IOException("Premature EOF reached.");
                }
                buf.append((char)((v1 << 8) + v2));
            }
            this.statement.setVar(parameterIndex - 1, StringObject.fromString(new String(buf)));
        } else {
            throw new RuntimeException("Do not understand type.");
        }
    }

    public void close() throws SQLException {
        super.close();
        this.statement = null;
    }

    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(this.statement);
    }

    public int executeUpdate() throws SQLException {
        MResultSet result_set = this.executeQuery(this.statement);
        return result_set.intValue();
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.statement.setVar(parameterIndex - 1, null);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.statement.setVar(parameterIndex - 1, new Boolean(x));
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setLong(parameterIndex, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setLong(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setLong(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.statement.setVar(parameterIndex - 1, BigNumber.fromLong(x));
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.statement.setVar(parameterIndex - 1, BigNumber.fromFloat(x));
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.statement.setVar(parameterIndex - 1, BigNumber.fromDouble(x));
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 2);
        } else {
            this.statement.setVar(parameterIndex - 1, BigNumber.fromBigDecimal(x));
        }
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 12);
        } else if (x.length() <= 4096) {
            this.statement.setVar(parameterIndex - 1, StringObject.fromString(x));
        } else {
            this.setCharacterStream(parameterIndex, (Reader)new StringReader(x), x.length());
        }
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, -2);
        } else if (x.length <= 8192) {
            ByteLongObject b = new ByteLongObject(x);
            this.statement.setVar(parameterIndex - 1, b);
        } else {
            this.setBinaryStream(parameterIndex, (InputStream)new ByteArrayInputStream(x), x.length);
        }
    }

    public void extSetDate(int parameterIndex, java.util.Date x) throws SQLException {
        this.statement.setVar(parameterIndex - 1, x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 91);
        } else {
            this.extSetDate(parameterIndex, new java.util.Date(x.getTime()));
        }
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 92);
        } else {
            this.extSetDate(parameterIndex, new java.util.Date(x.getTime()));
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 93);
        } else {
            long time = x.getTime();
            if (!TIMESTAMP_VALUE_INCLUDES_NANOS) {
                time += (long)(x.getNanos() / 1000000);
            }
            this.extSetDate(parameterIndex, new java.util.Date(time));
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, -1);
        } else {
            try {
                this.setVariableLengthStream(parameterIndex, x, length, (byte)3);
            }
            catch (IOException e) {
                throw new SQLException("IOException reading input stream: " + e.getMessage());
            }
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("Deprecated method not supported");
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, -2);
        } else {
            try {
                this.setVariableLengthStream(parameterIndex, x, length, (byte)2);
            }
            catch (IOException e) {
                throw new SQLException("IOException reading input stream: " + e.getMessage());
            }
        }
    }

    public void clearParameters() throws SQLException {
        this.statement.clear();
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, targetSqlType);
        } else {
            if ((x = this.convertToType(x, targetSqlType)) instanceof BigDecimal) {
                x = ((BigDecimal)x).setScale(scale, 4);
            }
            this.statement.setVar(parameterIndex - 1, x);
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, targetSqlType);
        } else {
            this.statement.setVar(parameterIndex - 1, this.convertToType(x, targetSqlType));
        }
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.statement.setVar(parameterIndex - 1, this.castToMckoiObject(x));
    }

    public boolean execute() throws SQLException {
        MResultSet result_set = this.executeQuery(this.statement);
        return !result_set.isUpdate();
    }

    public void addBatch() throws SQLException {
        this.addBatch(this.statement.copy());
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        if (reader == null) {
            this.setNull(parameterIndex, -1);
        } else {
            try {
                this.setVariableLengthStream(parameterIndex, new UnicodeToBinaryStream(reader), length * 2, (byte)4);
            }
            catch (IOException e) {
                throw new SQLException("IOException reading input stream: " + e.getMessage());
            }
        }
    }

    public void setRef(int i, Ref x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void setBlob(int i, Blob x) throws SQLException {
        if (x == null) {
            this.setNull(i, 2004);
        } else {
            long len = x.length();
            if (len >= 0x80000000L) {
                throw new SQLException("BLOB > 2 gigabytes is too large.");
            }
            this.setBinaryStream(i, x.getBinaryStream(), (int)len);
        }
    }

    public void setClob(int i, Clob x) throws SQLException {
        if (x == null) {
            this.setNull(i, 2005);
        } else {
            long len = x.length();
            if (len >= 0x40000000L) {
                throw new SQLException("CLOB > 1 billion characters is too large.");
            }
            this.setCharacterStream(i, x.getCharacterStream(), (int)len);
        }
    }

    public void setArray(int i, Array x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        throw MSQLException.unsupported();
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.setDate(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setTime(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(parameterIndex, x);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(paramIndex, sqlType);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw MSQLException.unsupported();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw MSQLException.unsupported();
    }

    public String toString() {
        return this.statement.toString();
    }
}

